<?php
use Phalcon\Mvc\View;
use Phalcon\DI\FactoryDefault;
use Phalcon\Mvc\Url as UrlProvider;
use Phalcon\Mvc\View\Engine\Php as PhpEngine;
use Phalcon\Mvc\Url as UrlResolver;
use Phalcon\Mvc\View\Engine\Volt as VoltEngine;
use Phalcon\Mvc\Model\Metadata\Memory as MetaDataAdapter;
use Phalcon\Session\Adapter\Files as SessionAdapter;
use Phalcon\Flash\Direct as FlashDirect;
use Phalcon\Flash\Session as FlashSession;
use Phalcon\Mvc\Dispatcher;
use Phalcon\Session\Factory as Factory;

use Phalcon\Mvc\Dispatcher as MvcDispatcher;
use Phalcon\Events\Event;
use Phalcon\Events\Manager as EventsManager;
use Phalcon\Mvc\Router as Router;
use Phalcon\Http\Response\Cookies;/**jhuaman*/

use Phalcon\Logger;
use Phalcon\Logger\Adapter\File as FileAdapter;

/**
 * Shared configuration service
 */
$di->setShared('config', function () {
    return include APP_PATH . "/config/config.php";
});

$di->set('router', function() 
{
    $router = new Router();
    // Definir una ruta
    $router->add(
        '/p/:params',
        [
            'controller' => 'p',
            'action'     => 'index',
            'params'     => 1,
        ]
    );
    
    return $router;
});

/**
 * The URL component is used to generate all kind of urls in the application
 */
$di->setShared('url', function () {
    $config = $this->getConfig();

    $url = new UrlResolver();
    $url->setBaseUri($config->application->baseUri);

    return $url;
});

/**
 * Setting up the view component
 */
$di->setShared('view', function () {
    $config = $this->getConfig();

    $view = new View();
    $view->setDI($this);
    $view->setViewsDir($config->application->viewsDir);

    $view->registerEngines([
        '.volt' => function ($view) {
            $config = $this->getConfig();

            $volt = new VoltEngine($view, $this);
            
            $volt->setOptions([
                'compiledPath' => $config->application->cacheDir,
                'compiledSeparator' => '_'
            ]);

            return $volt;
        },
        '.phtml' => PhpEngine::class

    ]);

    return $view;
});

$di->set('dispatcher', function () {
    
    // Crear un nuevo gestor de eventos
    $eventsManager = new EventsManager();

    // Estar atento por eventos producidos en el distribuidor usando el plugin Security
    $eventsManager->attach('dispatch:beforeExecuteRoute', new SecurityPlugin);

    // Maneja excepciones y excepciones no encontradas usando NotFoundPlugin
    $eventsManager->attach('dispatch:beforeException', new NotFoundPlugin);

    $dispatcher = new Dispatcher();

    // Asignar el gestor de eventos al despachador
    $dispatcher->setEventsManager($eventsManager);

    return $dispatcher;
});

$di->set("elements", function () {
        return new Elements();
    }
);

use Phalcon\Crypt;

$di->set('crypt', function () {
        $crypt = new Crypt();

        // Clave de seguridad global
        $crypt->setKey(
            'syscastaneda_facturalaya'
        );

        return $crypt;
    },
    true
);

/**
 * Database connection is created based in the parameters defined in the configuration file
 */
$di->setShared('db', function () {
    $config = $this->getConfig();

    $class = 'Phalcon\Db\Adapter\Pdo\\' . $config->database->adapter;
    $params = [
        'host'     => $config->database->host,
        'username' => $config->database->username,
        'password' => $config->database->password,
        'dbname'   => $config->database->dbname,
        'charset'  => $config->database->charset
    ];

    if ($config->database->adapter == 'Postgresql') {
        unset($params['charset']);
    }

    $connection = new $class($params);

    return $connection;
});


/**
 * If the configuration specify the use of metadata adapter use it or use memory otherwise
 */
$di->setShared('modelsMetadata', function () {
    return new MetaDataAdapter();
});

/**
 * Register the session flash service with the Twitter Bootstrap classes
 */
// Set up the flash service
$di->set(
    "flash",
    function () {
        return new FlashDirect();
    }
);

// Set up the flash session service
$di->set(
    "flashSession",
    function () {
        return new FlashSession();
    }
);

// Register the flash service with custom CSS classes
$di->set(
    "flash",
    function () {
        $flash = new FlashDirect(
            [
                "error"   => "alert alert-danger",
                "success" => "alert alert-success",
                "notice"  => "alert alert-info",
                "warning" => "alert alert-warning",
            ]
        );

        return $flash;
    }
);

$di->set(
    "flashSession",
    function () {
        $flash = new FlashSession(
            [
                "error"   => "alert alert-danger",
                "success" => "alert alert-success",
                "notice"  => "alert alert-info",
                "warning" => "alert alert-warning",
            ]
        );

        return $flash;
    }
);

/**
 * Start the session the first time some component request the session service
 */
$di->setShared('session', function () {
    // Set the max lifetime of a session with 'ini_set()' to one hour
    ini_set("session.cookie_lifetime", 99999);
    ini_set("session.gc_maxlifetime", 99999);
    session_set_cookie_params(99999, '/');

    $session = new SessionAdapter();

    if(!$session->isStarted()){
        $options = [
            'persistent' => true,
            'lifetime'   => 9999
        ];
        try {
            $session->setOptions($options);
            $session->start();
        } catch (Exception $e) {
            error_log("Session start failed: " . $e->getMessage());
            error_log("Stack trace: " . $e->getTraceAsString());
        }
    }
    return $session;
});

/**jhuaman*/
$di->setShared('cookies',function () {
        $cookies = new Cookies();
        $cookies->useEncryption(false);
        return $cookies;
    }
);

?>