<?php
/*
Plugin Name: iGuiderWP
Plugin URI: http://codecanyon.net/user/yurik417/portfolio
Description: Horizontal and vertical scrolling of text or image or html code WordPress plugin.
Version: js.4.3-wp.1.0
Author: MASSCODE
Author URI: http://codecanyon.net/user/yurik417/portfolio
*/

//define( 'WP_DEBUG', true );

/*
This class isolates the code from the names conflict
*/
class iGuiderClass {
	/*
	Constants defining
	*/
	private $pluginCssPath = '/css/iGuider.css';							//The path to plugin file styles 
	private $pluginJsPath = '/js/jquery.iGuider.js';						//The path to plugin file script
	 
	private $pluginThemeCssPath = '/themes/material/iGuider-theme-material.css';	//The path to plugin theme file styles
	private $pluginThemeJsPath = '/themes/material/iGuider-theme-material.js';		//The path to plugin theme script 
	
	private $pluginInitPath = '/js/init.iGuider.js';						//The path to plugin initialization file

	/*
	This feature adds hooks to all the functions you need
	*/
	function __construct() {
		/*
		This hook is a File connection function to the page of the site
		*/
		add_action( 'wp_enqueue_scripts', array (&$this, 'addPluginFiles'));
	}

	/*
	This function connects the plug-in files on the web page
	*/
	function addPluginFiles(){
		if(!is_admin()) {
			
			/*
			Identify our files
			*/
			wp_register_style(dirname(plugin_basename(__FILE__)).'styles',WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__)).$this->pluginCssPath,false,all);
			wp_register_script('jquery.'.dirname(plugin_basename(__FILE__)),WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__)).$this->pluginJsPath,array( 'jquery' ),"1.3",1);
			
			wp_register_style(dirname(plugin_basename(__FILE__)).'theme',WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__)).$this->pluginThemeCssPath,false,all);
			wp_register_script('theme.'.dirname(plugin_basename(__FILE__)),WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__)).$this->pluginThemeJsPath,array( 'jquery' ),"1.0",1);
			
			wp_register_script('init.'.dirname(plugin_basename(__FILE__)),WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__)).$this->pluginInitPath,array( 'jquery' ),"1.0",1);
			
			/*
			Then enqueue them
			*/
			wp_enqueue_style(dirname(plugin_basename(__FILE__)).'styles');
			wp_enqueue_style(dirname(plugin_basename(__FILE__)).'theme');
			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery.'.dirname(plugin_basename(__FILE__)));
			wp_enqueue_script('theme.'.dirname(plugin_basename(__FILE__)));
			wp_enqueue_script('init.'.dirname(plugin_basename(__FILE__)));
		}
	}
}

/*
create a variable with instance of the class
*/
$iGuiderClass = new iGuiderClass ();
?>