<?php

use Phalcon\Acl;
use Phalcon\Acl\Role;
use Phalcon\Acl\Resource;
use Phalcon\Events\Event;
use Phalcon\Mvc\User\Plugin;
use Phalcon\Mvc\Dispatcher;
use Phalcon\Acl\Adapter\Memory as AclList;
use Phalcon\Session as Session;
/**
 * SecurityPlugin
 *
 * This is the security plugin which controls that users only have access to the modules they're assigned to
 */
class SecurityPlugin extends Plugin {

	public function getAcl() {
		$acl = new AclList();
		$acl->setDefaultAction(Acl::DENY);
		
		$roles = array(
			'super_admin' => new Role('super_admin'),
			'super_soporte' => new Role('super_soporte'),
			'contribuyente_admin' => new Role('contribuyente_admin'),
			'contribuyente_vendedor' => new Role('contribuyente_vendedor'),
			'guest' => new Role('guest')
		);

		//registramos todos los roles en el ACL
		foreach ($roles as $role) {
			$acl->addRole($role);
		}
		
		/* ÁREAS DEL SUPER ADMINISTRADOR */
		$Super_adminAreas = array(
			'areaadministracion'	=> array('index')
		);

		foreach ($Super_adminAreas as $resource => $actions) {
			$acl->addResource(new Resource($resource), $actions);
		}
		
		/* ÁREAS DEL SUPER SOPORTE */
		$Super_soporteAreas = array(
			'clientearea' => array('index'),
			'gestiondecontribuyentes' => array('asignar_p_s', 'asignar_pse_facturalaya', 'index', 'guardar', 'get_data_api_busquedas', 'get_patrocinadores', 'get_data_contribuyente', 'configuracion', 'get_lista_contribuyentes', 'get_membresia', 'guardar_membresia', 'guardar_fecha_suscripcion', 'guardar_expira_certificado', 'convertir_en_jefe_grupo', 'cambiar_tipo_empresa_sunat', 'quitar_pse_facturalaya', 'ver_estadisticas_contribuyente'),
			'gestiondeplantillas' => array('index', 'save', 'get_list_plantilla', 'get_data_plantilla','eliminar_plantilla', 'preview_template'),
			'dashboardadmin' => array('index', 'get_lista_docs_sunat', 'verificar_estado_sunat', 'modificar_docelectronico'),
			'gestiondedocumentos'	=> array('index', 'get_lista_docs_sunat', 'verificar_estado_sunat', 'modificar_docelectronico', 'enviar_documento_sunat', 'crear_resumen_individual', 'procesar_facturas_notas', 'crear_resumen_individual', 'procesar_boletas_notas', 'consultar_ticket', 'ignorar_documento', 'guardar_fecha_documento', 'proceso_total_doc_sunat', 'proceso_validacion_cpe'),
			'gestionplantillaspdf' => array('index', 'guardar_plantilla', 'get_lista_plantillaspdf','get_data_plantillapdf','eliminar_plantillapdf'),
			'gestionpersonalizarsistema' => array('index', 'guardar_diseno', 'get_lista_diseno','get_data_diseno','eliminar_diseno'),
			'administracionproductos' => array('index','get_list_contribuyente'),
			'prueba'	=> array('copiar_productos', 'prueba_permisos_usuario')
		);

		foreach ($Super_soporteAreas as $resource => $actions) {
			$acl->addResource(new Resource($resource), $actions);
		}

		/* ÁREAS DEL CONTRIBUYENTE ADMINISTRADOR */
		$Contribuyente_adminAreas = array(
			'registradocliente' => array('index'),
			'download' => array('sysfacturacion', 'themescpe', 'themeadmin'),
			'configcompany' => array('index','get_data_contribuyente', 'guardar', 'generar_token_contribuyente', 'eliminar_logo'),

			'gestiondecontribuyentes' => array('index', 'guardar', 'get_data_api_busquedas', 'get_patrocinadores', 'get_data_contribuyente', 'configuracion', 'get_lista_contribuyentes', 'get_membresia', 'guardar_membresia'),
			
			'reportes' => array('index', 'crear_reporte', 'libro_ecompras', 'get_detallecompras', 'generar_txt_libcompras', 'libro_eventas', 'generar_txt_libventas','reporte_detallado', 'get_reportedetallado', 'reporte_detallado_compras', 'actualizar_tipo_cambio_ventas', 'actualizar_tipo_cambio_compras', 'get_reporte_guias', 'get_reporte_general_ventas'),
			'branchoffice' => array('index','insert', 'get_sucursal', 'lista_sucursales', 'cambiar_estado_sucursal', 'get_lista_sucursales', 'get_plantillas_user', 'guardar_opcion_items'),
			'gestionuser' => array('index','insert', 'get_lista_usuarios', 'eliminar_usuario', 'get_data_usuario'),
			'listacontribuyentes' => array('index'),
			'listbranchoffice' => array('index'),
			'dashboard' => array('index', 'get_datos_estadisticos', 'get_lista_doc_pendientes', 'verificar_estado_sunat', 'modificar_docelectronico', 'save_config_modalidad_pago', 'download_plantilla_cpe'),
			'gestioncuentadebanco'	=> array('index','save','get_lista_cuenta','get_data_cuenta','eliminar_cuenta'),
			'gestioncondiciondepago'	=> array('index','save','get_lista_condicionpago','get_data_condicionpago','eliminar_condicionpago'),
			'miwebsite' => array('index', 'saveimage', 'get_templates', 'guardar_data', 'get_paginas', 'crear_nueva_pagina', 'eliminar_pagina', 'cambiar_home'),
			'editorweb' => array('index', 'view_edit_page', 'get_data_page', 'guardar_pagina'),
			'producto'	=> array('export_to_excel', 'export_to_update', 'actualizar_productos', 'update_cell'),
			'importacioncpe' => array('plantilla_importacion_cpe', 'iniciar_proceso_importacion'),
			'gestiondeetiquetas' => array('guardar_etiqueta', 'eliminar_etiqueta', 'get_lista_etiquetas', 'asignar_etiquetaxdocumento'),
			'personalizaciondesistema' => array('index', 'save_color','deshacer_diseno','save_template_login','save_template_registro', 'get_data_personalizacion','save_mensaje_sub','guardar_logo_dominios', 'guardar_imagen_servidor', 'save_background_login', 'save_background_registro', 'guardar_dominio_logos', 'guardar_color_base_sistema', 'reiniciar_colores_base')
		);

		foreach ($Contribuyente_adminAreas as $resource => $actions) {
			$acl->addResource(new Resource($resource), $actions);
		}

		/* ÁREAS DEL CONTRIBUYENTE VENDEDOR */
		$Contribuyente_vendedorAreas = array(
			'producto' => array('index','index2','registrar_producto','registrar_imagenes','listaproductos','insert','get_data_producto','eliminar_producto', 'get_lista_productos', 'get_lista_categorias', 'agregar_categoria', 'importar_productos', 'registrar_salida_producto', 'registrar_ingreso_producto', 'iniciar_traslado', 'imprimir_codigobarras', 'get_sugerencias_marcas', 'update_cell', 'descargar_plantilla_importacion', 'iniciar_proceso_transformacion'),
			'importacionproductos' => array('importar_productos'),
			'category' => array('index','insert', 'get_lista_categorias', 'eliminar_categoria', 'get_data_categoria', 'get_sugerencias_categorias'),
			'client' => array('index','insert', 'get_lista_clientes', 'eliminar_cliente', 'get_data_cliente', 'get_lista_sugerencias_clientes', 'descargar_plantilla_importacion', 'importar_clientes'),
			'reportedocumentos' => array('index', 'get_lista_documentos', 'enviar_documento_sunat', 'get_notas_de_venta', 'get_cotizaciones', 'get_lista_guias_remision', 'anular_doc_no_oficial', 'get_lista_guias_transportista'),
			'resumendeboletas' => array('index', 'get_lista_facturas', 'crear_resumen_boletas', 'crear_resumen_boletas', 'get_lista_resumenes', 'get_items_resumen_creado', 'consultar_ticket', 'crear_resumen_individual'),
			'resetpassword' => array('index'),
			'herramientas' => array('generartoken', 'get_lista_sucursales', 'get_data_cliente', 'get_data_sucursal', 'get_sugerencias_producto', 'get_sugerencias_docelectronico', 'saveimage', 'save_user', 'get_sugerencias_clientes', 'get_sugerencias_clientes_mejorado', 'get_lista_usuarios', 'get_data_proveedor', 'enviar_cpe_email', 'get_sugerencias_ubigeos', 'verimageprod', 'guardar_imagen_producto', 'get_sugerencias_proveedor'),
			'documentoelectronico' => array('index', 'get_data_producto', 'guardar_documento', 'get_documento_electronico', 'download_cpe_cdr', 'get_data_doc'),
			'apisunat' => array('get_tipo_cambio', 'get_lista_ubigeos', 'get_lista_monedas', 'get_unidadesmedida', 'get_lista_tipoafectacionigv', 'get_codigodetraccion', 'get_lista_tipo_doc_identidad', 'get_sunat_tiponotacredito', 'get_sunat_tiponotadebito', 'get_lista_codprod_segmentos', 'get_lista_codprod_codigoproducto', 'get_lista_sugerencias_ubigeo', 'get_tipo_cambio_by_date'),
			'profile' => array('index','save', 'save_email', 'save_password'),
			'comunicaciondebaja' => array('index', 'get_info_documento', 'crear_comunicacion_baja'),
			'guiaderemision' => array('index', 'get_empresastransporte', 'get_lista_conductores_autos', 'get_documentos_cliente', 'guardar_guia_remision', 'sugerencias_transportista', 'sugerencias_direcciones_llegada', 'iniciar_importacion_items'),
			'empresasdetransporte' => array('index', 'get_data_empresa', 'get_lista_empresa','eliminar_empresa','save','verificar_ruc', 'eliminar_conductor','eliminar_vehiculo'),
			'reportes' => array('index', 'crear_reporte', 'libro_ecompras', 'get_detallecompras', 'generar_txt_libcompras', 'libro_eventas', 'generar_txt_libventas','reporte_detallado', 'get_reportedetallado', 'reporte_productosvendidos', 'get_reporteproductosvendidos', 'top_vendedores', 'top_clientes', 'get_top_clientes', 'get_detalle_docs_by_idcliente', 'get_top_vendedores', 'get_detalle_docs_by_idvendedor', 'generar_excel_libventas', 'generar_excel_ventas_ejb', 'liquidacion_impuesto_mensual', 'get_liquidacion_mensual', 'get_formato_cm', 'get_asiento_contable', 'get_reporte_detallado_compras', 'reporte_detallado_compras', 'get_reporte_guias', 'get_reporte_general_ventas'),
			'dashboard' => array('index', 'get_datos_estadisticos', 'get_lista_doc_pendientes', 'guardar_condicion_pago'),
			'centrodeentrenamiento' => array('index'),
			'gestiondecompras' => array('index', 'registrarcompra', 'guardar_compra', 'get_lista_compras', 'anular_compra', 'get_datos_estadisticos','get_header_doccompra','get_detalle_doccompra','get_detalle_compra', 'get_data_cpe', 'get_top_proveedores', 'procesar_xml_cpe'),
			'notificacion' => array('index', 'get_lista_doc_pendientes','notificaciones', 'get_fecha_tope','get_numtotal_docs_pendientes'),
			'gestiondeproveedores' =>  array('index','insert', 'get_lista_proveedores', 'eliminar_proveedores', 'get_data_proveedores', 'get_lista_sugerencias_proveedor'),
			'reportekardex' =>  array('index', 'kardexdeproducto', 'get_kardex_producto', 'get_inv_valorizado_sunat_prod'),
			'estadosuscripcion' => array('index'),
			'cajachica' => array('index','save','get_lista_movimientos', 'get_data_movimiento', 'delete','reporte_detallado', 'get_totales_ventas', 'reporte_ticket', 'download_ticket', 'detallecajachica', 'get_hoja_liquidacion', 'imprimir_ticket_movimiento'),
			'gestiondeprospectos' => array('index','prueba', 'save','get_data_prospecto','get_lista_prospectos', 'eliminar_prospecto', 'agregar_etiqueta', 'eliminar_etiqueta','agregar_telefono','agregar_correo','get_data_nota', 'guardar_nota'),
			'cuentasporcobrar'	=> array('index', 'get_lista_cpe', 'get_lista_notaventa', 'get_lista_abonos', 'guardar_abono', 'eliminar_abono', 'resetear_cuota', 'get_reporte_excel_cpe', 'get_reporte_excel_nventas', 'get_totales_monto_por_cobrar'),
			'cuentasporpagar'	=> array('index', 'get_lista_cpe', 'get_lista_notaventa', 'get_lista_abonos', 'crear_abono_pago'),
			'download'	=> array('ticket_abono', 'download_cotisiscompleto', 'download_cotiservfact'),
			'suscripcion' => array('index', 'activar_suscripcion','index2'),
			'templatepdf1' => array('index','get_html_plantilla_a4_1'),
			'pruebacolores' => array('index', 'save','get_color','deshacer_diseno'),
			'gestiondeetiquetas' => array('get_lista_etiquetas', 'asignar_etiquetaxdocumento'),
			'productomovimientos' => array('get_lista_movimientos', 'print_pdf'),
			'gestionrestaurante'	=> array('index','dashboard','iniciarcuenta','cocina','reserva','gestioncocina', 'gestionreservas', 'reserva2'),
			'creargremasivo' => array('index', 'plantilla_crear_gre_masivo', 'iniciar_proceso_creacion_gre'),
			'guiatransportista'	=> array('index', 'sugerencias_destinatario', 'sugerencias_conductor', 'sugerencias_datos_transportista', 'guardar_guia_transportista'),
			'ordendecompra'	=> array('anular_orden_compra'),
		);

		foreach ($Contribuyente_vendedorAreas as $resource => $actions) {
			$acl->addResource(new Resource($resource), $actions);
		}

		//Recursos para los usuarios GUEST
		$GuestAreas = array(
			'herramientas'	=> array('verimage', 'imageclie', 'logo_empresa_v1', 'logo_empresa_v2', 'verimagepersonalizacion', 'verimageprod'), 
			'index'			=> array('index'),
			'errors'		=> array('show401', 'show404', 'show500'),
			'login'			=> array('index','index_anterior','index2', 'login_02','recoverpassword_02','recoverpassword_03','recoverpassword_04','recoverpassword_05','recoverpassword_06','recoverpassword_07','recoverpassword_08','login_03','login_04','login_05','login_06','login_07','login_08','session', 'logout', 'end','resetpassword', 'recoverpassword','recovery','newpassword','change_password', 'registrar_usuario', 'cambiar_password', 'inicio_sesion_remoto', 'login_remoto'),
			'consultas'		=> array('index', 'consultar'),
			'download' 		=> array('downloadpdf', 'downloadcpe', 'resumen', 'verpdf'),
			'registro'		=> array('index','registrar_usuario','registro_01','registro_02','registro_03','registro_04','registro_05','registro_06','registro_07'),
			'prueba'		=> array('index', 'prueba_guia_remision', 'prueba_cotizacion', 'nota_venta', 'cpe', 'nombres'),
			'terminoslegales'		=> array('index', 'terminos_del_servicio'),
			'reset_password'	=> array('index'),
			'registrarse' => array('index'),
			'api'			=> array('index', 'procesar_venta', 'buscar_data_cliente', 'get_producto', 'get_productos', 'procesar_notacredito', 'procesar_notadebito', 'procesar_guia_remision', 'procesar_nota_venta', 'procesar_cotizacion', 'get_num_productos', 'enviar_cpe_email', 'comunicacion_baja', 'user_login', 'registrar_contribuyente', 'get_data_cpe', 'get_libro_eventas', 'get_detalle_cpe', 'buscar_productos'),
			'printpdf'	=> array('index', 'prueba'),
			'templatenotapedido' => array('get_html_plantilla_a4_1','get_html_plantilla_a4_2','get_html_plantilla_a4_3', 'get_html_plantilla_a4_4', 'get_html_plantilla_a4_5','get_html_plantilla_a4_6', 'get_html_plantilla_a4_7','get_html_plantilla_a4_8', 'get_html_plantilla_ticket_1', 'get_html_plantilla_ticket_2', 'get_html_plantilla_ticket_3'),
			'templatecotizacion' => array('get_html_plantilla_a4_1','get_html_plantilla_a4_2','get_html_plantilla_a4_3',  'index','get_html_plantilla1', 'get_html_plantilla2','get_html_plantilla3', 'get_html_plantilla4','get_html_plantilla5','get_html_plantilla6'),
			'templateguiaremision' => array('get_html_plantilla_a4_1','get_html_plantilla_a4_2','get_html_plantilla_a4_3', 'get_html_plantilla_a4_4', 'get_html_plantilla_a4_5','get_html_plantilla_a4_6', 'get_html_plantilla_a4_7','get_html_plantilla_a4_8', 'get_html_plantilla_ticket_1', 'get_html_plantilla_ticket_2', 'get_html_plantilla_ticket_3'),
			'codigosdeerrorsunat'	=> array('index', 'get_lista_errores'),

			'apiapp'	=> array('index', 'login', 'refresh_token', 'get_user_info')
			
		);

		foreach ($GuestAreas as $resource => $actions) {
			$acl->addResource(new Resource($resource), $actions);
		}

		//otorgando acceso a todos los usuarios a las areas para visitantes
		foreach($roles as $role){
		    foreach($GuestAreas as $resource => $actions){
		    	foreach ($actions as $action){
					$acl->allow($role->getName(), $resource, $action);
				}
		    }
		}
		
		//Damos Acceso a las áreas de Super_Admin solo a los super_admin
		foreach ($Super_adminAreas as $resource => $actions) {
			foreach ($actions as $action){
				$acl->allow('super_admin', $resource, $action);
			}
		}

		//Damos Acceso a las áreas de super_soporte tanto a los super_admin como a los super_soporte
		foreach ($Super_soporteAreas as $resource => $actions) {
			foreach ($actions as $action){
				$acl->allow('super_admin', $resource, $action);
				$acl->allow('super_soporte', $resource, $action);
			}
		}

		//Damos Acceso a las áreas de usuarioregistrado a todos los usuarios registrados y también a los clientes y admin.
		foreach ($Contribuyente_adminAreas as $resource => $actions) {
			foreach ($actions as $action){
				$acl->allow('super_admin', $resource, $action);
				$acl->allow('super_soporte', $resource, $action);
				$acl->allow('contribuyente_admin', $resource, $action);
			}
		}

		//Damos Acceso a las áreas de contribuyente_vendedor a todos los usuarios vendedores
		foreach ($Contribuyente_vendedorAreas as $resource => $actions) {
			foreach ($actions as $action){
				$acl->allow('super_admin', $resource, $action);
				$acl->allow('super_soporte', $resource, $action);
				$acl->allow('contribuyente_admin', $resource, $action);
				$acl->allow('contribuyente_vendedor', $resource, $action);
			}
		}

		//Damos Acceso a las áreas de guest o visitantes a los siguientes roles: admin, cliente, registrado, guest
		foreach ($GuestAreas as $resource => $actions) {
			foreach ($actions as $action){
				$acl->allow('super_admin', $resource, $action);
				$acl->allow('super_soporte', $resource, $action);
				$acl->allow('contribuyente_admin', $resource, $action);
				$acl->allow('contribuyente_vendedor', $resource, $action);
				$acl->allow('guest', $resource, $action);
			}
		}

		$this->persistent->acl = $acl;
		return $this->persistent->acl;
	}

	//Para la versión anterior de phalcon se utilizaba: public function beforeDispatch(Event $event, Dispatcher $dispatcher) {
	public function beforeExecuteRoute(Event $event, Dispatcher $dispatcher) {
		error_reporting(E_ALL); 
		ini_set("display_errors", 1);

		//creamos una instancia de logger
		$controller = $dispatcher->getControllerName();
		$action = $dispatcher->getActionName();
		
		$auth = $this->session->get('auth');
		if($controller == 'login' && in_array($action, array('logout', 'inicio_sesion_remoto', 'login_remoto'))) {
			
		} else {
			if(!$auth) {
				if ($this->cookies->has('logout_c_5939')) {
					$rememberMeCookie = $this->cookies->get('logout_c_5939');
					$texto_encriptado = $rememberMeCookie->getValue();
					$herramientas = new HerramientasController;
					$texto_desencriptado = $herramientas->desencriptar($texto_encriptado);
					$dia_actual = date('dmY');
					$array_datos = explode("||", $texto_desencriptado);
					$id_usuario = isset($array_datos[0])?$array_datos[0]:0;
					$dia_actual_cookie = isset($array_datos[1])?$array_datos[1]:'';
					if($dia_actual == $dia_actual_cookie) {
						$user = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $id_usuario)));
						if($user) {
							$login = new LoginController;
							//$login->login_laravel($user->nombre, $user->apellido, $user->email, $user->password, $user->id_contribuyente);
							$login->crear_nueva_session($user, false);
						}
					}
				}
	
				$auth = $this->session->get('auth');
			}
		}
		
		if (!$auth){
			$role = 'guest';
		} else {
			$role = $auth["rol"];
		}
		
		$acl = $this->getAcl();
		
		if (!$acl->isResource($controller)) {
			
			$dispatcher->forward([
				'controller' => 'errors',
				'action'     => 'show404'
			]);
			return false;
		}
		
		$allowed = $acl->isAllowed($role, $controller, $action);
		
		if ($allowed != Acl::ALLOW) {
			$dispatcher->forward(array(
				'controller' => 'errors',
				'action'     => 'show401'
			));
			return false;
		}
	}
}
?>