<?php

use Phalcon\Validation;
use Phalcon\Validation\Validator\Email as EmailValidator;

class Sucursal extends \Phalcon\Mvc\Model
{

    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $idsucursal;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_contribuyente;

    /**
     *
     * @var string
     * @Column(type="string", length=14, nullable=false)
     */
    public $codigo;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=false)
     */
    public $nombre;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=false)
     */
    public $direccion;

    /**
     *
     * @var string
     * @Column(type="string", length=6, nullable=false)
     */
    public $id_ubigeo;

    /**
     *
     * @var string
     * @Column(type="string", length=150, nullable=false)
     */
    public $urbanizacion;

    /**
     *
     * @var string
     * @Column(type="string", length=50, nullable=false)
     */
    public $telefono;

    /**
     *
     * @var string
     * @Column(type="string", length=100, nullable=false)
     */
    public $email;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $informacion_adicional;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_registro;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $estado;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $factura_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $factura_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $factura_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $boleta_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $boleta_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $boleta_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $notacredito_factura_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $notacredito_factura_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $notacredito_factura_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $notadebito_factura_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $notadebito_factura_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $notadebito_factura_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $notacredito_boleta_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $notacredito_boleta_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $notacredito_boleta_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $notadebito_boleta_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $notadebito_boleta_numero;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $notadebito_boleta_formato;
    
    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $guia_remision_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $guia_remision_numero;

    public $guia_transportista_serie;
    public $guia_transportista_numero;
    public $guia_transportista_formato;
    public $orden_compra_serie;
    public $orden_compra_numero;
    public $orden_compra_formato;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $guia_remision_formato;
    public $leyenda_comprobantes;

    public $txt_pdf_a4_1;
    public $txt_pdf_a4_2;
    public $txt_pdf_a4_3;
    public $txt_pdf_ticket_1;
    public $txt_pdf_ticket_2;
    public $txt_pdf_ticket_3;
    public $plantilla_pdf_a4;
    public $plantilla_pdf_ticket;
    public $sitio_web;

    public $id_plantillapdf_factura_a4;
    public $id_plantillapdf_factura_ticket;
    public $id_plantillapdf_boleta_a4;
    public $id_plantillapdf_boleta_ticket;
    public $id_plantillapdf_notacredito_a4;
    public $id_plantillapdf_notacredito_ticket;
    public $id_plantillapdf_notadebito_a4;
    public $id_plantillapdf_notadebito_ticket;
    public $id_plantillapdf_guiaremision_a4;
    public $id_plantillapdf_guiaremision_ticket;
    public $id_plantillapdf_notaventa_a4;
    public $id_plantillapdf_notaventa_ticket;
    public $id_plantillapdf_cotizacion_a4;
    public $id_plantillapdf_cotizacion_ticket;
    public $id_plantillapdf_guiatransportista_a4;
    public $id_plantillapdf_guiatransportista_ticket;
    public $id_plantillapdf_ordencompra_a4;
    public $id_plantillapdf_ordencompra_ticket;
    
    public $boleta_mostrar_items_igv;
    public $factura_mostrar_items_igv;
    public $notacredito_mostrar_items_igv;
    public $notadebito_mostrar_items_igv;
    public $guiaremision_mostrar_items_igv;
    public $cotizacion_mostrar_items_igv;
    public $notaventa_mostrar_items_igv;
    public $ordencompra_mostrar_items_igv;

    public $factor_igv;

    public $boleta_mostrar_yape;
    public $factura_mostrar_yape;
    public $notaventa_mostrar_yape;
    public $boleta_mostrar_plin;
    public $factura_mostrar_plin;
    public $notaventa_mostrar_plin;
    public $cotizacion_mostrar_yape;
    public $cotizacion_mostrar_plin;

    public $img_qr_yape;
    public $titular_yape;
    public $celular_yape;
    public $img_qr_plin;
    public $titular_plin;
    public $celular_plin;

    /**
     * Validations and business logic
     *
     * @return boolean
     */
    public function validation()
    {
        $validator = new Validation();

        $validator->add(
            'email',
            new EmailValidator(
                [
                    'model'   => $this,
                    'message' => 'Please enter a correct email address',
                ]
            )
        );

        return $this->validate($validator);
    }

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $this->setSchema("juantufacturaya_sisv7");
        $this->setSource("sucursal");
    }

    /**
     * Returns table name mapped in the model.
     *
     * @return string
     */
    public function getSource()
    {
        return 'sucursal';
    }

    /**
     * Allows to query a set of records that match the specified conditions
     *
     * @param mixed $parameters
     * @return Sucursal[]|Sucursal|\Phalcon\Mvc\Model\ResultSetInterface
     */
    public static function find($parameters = null)
    {
        return parent::find($parameters);
    }

    /**
     * Allows to query the first record that match the specified conditions
     *
     * @param mixed $parameters
     * @return Sucursal|\Phalcon\Mvc\Model\ResultInterface
     */
    public static function findFirst($parameters = null)
    {
        return parent::findFirst($parameters);
    }

}
