<?php

class Categoria extends \Phalcon\Mvc\Model
{

    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $idcategoria;

    /**
     *
     * @var string
     * @Column(type="string", length=14, nullable=false)
     */
    public $codigo;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=false)
     */
    public $nombre;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $descripcion;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_contribuyente;

    /**
     *
     * @var string
     * @Column(type="string", length=8, nullable=true)
     */
    public $id_codigoproducto;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_registro;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $estado;

    public $codigo_cuenta_contable;
    public $codigo_centro_costo;
    public $codigo_presupuesto;

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $this->setSchema("juantufacturaya_sisv7");
        $this->setSource("categoria");
    }

    /**
     * Returns table name mapped in the model.
     *
     * @return string
     */
    public function getSource()
    {
        return 'categoria';
    }

    /**
     * Allows to query a set of records that match the specified conditions
     *
     * @param mixed $parameters
     * @return Categoria[]|Categoria|\Phalcon\Mvc\Model\ResultSetInterface
     */
    public static function find($parameters = null)
    {
        return parent::find($parameters);
    }

    /**
     * Allows to query the first record that match the specified conditions
     *
     * @param mixed $parameters
     * @return Categoria|\Phalcon\Mvc\Model\ResultInterface
     */
    public static function findFirst($parameters = null)
    {
        return parent::findFirst($parameters);
    }

}
