<?php
use Phalcon\Di\FactoryDefault;
define('BASE_PATH', dirname(__DIR__));
define('APP_PATH', BASE_PATH . '/app');

try {

    /**
     * The FactoryDefault Dependency Injector automatically registers
     * the services that provide a full stack framework.
     */
    $di = new FactoryDefault();

    /**
     * Handle routes
     */
    include APP_PATH . '/config/router.php';

    /**
     * Read services
     */
    include APP_PATH . '/config/services.php';

    include APP_PATH . '/config/custom_includes.php';

    /**
     * Get config service for use in inline setup below
     */
    $config = $di->getConfig();

    /**
     * Include Autoloader
     */
    include APP_PATH . '/config/loader.php';

    /**
     * Handle the request
     */
    $application = new \Phalcon\Mvc\Application($di);
    //NOTA: al parecer aparecen errores cuando en la plantilla se hacen llamados sin anteponer la palabra public en los assets
    //cuando pasa eso, entonces phalcon trata de encontrarlo como un controlador, al no existir lo busca en public, pero ya generó el error diciendo que la carpeta dentro de public (template por ejemplo) no existe
    echo str_replace(["\n","\r","\t"], '', $application->handle()->getContent());

} catch (\Exception $e) {
    echo $e->getMessage() . '<br>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}
