<?php
class LogsController extends ControllerBase
{
	public function indexAction() {

	}

	public function log_documento($data) {
		$id_contribuyente = $data['id_contribuyente'];
		$id_tipodoc_electronico = $data['id_tipodoc_electronico'];
		$serie_comprobante = $data['serie_comprobante'];
		$numero_comprobante = $data['numero_comprobante'];
		$tipo_envio_sunat = $data['tipo_envio_sunat'];
		$idusuario = $data['idusuario'];
		$tipo_log = $data['tipo_log'];
		$descripcion = isset($data['descripcion'])?$data['descripcion']:'';
		
		$array_cpe = array('01', '03', '07', '08', '09');
		
		if(in_array($id_tipodoc_electronico, $array_cpe)) {
			$documento = DocElectronico::findFirst(array("id_contribuyente = :id_contribuyente: and id_tipodoc_electronico = :id_tipodoc_electronico: and serie_comprobante = :serie_comprobante: and numero_comprobante = :numero_comprobante: and tipo_envio_sunat = :tipo_envio_sunat:", 'bind' => array('id_contribuyente' => $id_contribuyente, 'id_tipodoc_electronico' => $id_tipodoc_electronico, 'serie_comprobante' => $serie_comprobante, 'numero_comprobante' => $numero_comprobante, 'tipo_envio_sunat' => $tipo_envio_sunat)));
		} else {
			$serie_comprobante = (empty($serie_comprobante))?'NV01':$serie_comprobante;
			$documento = DocNoOficial::findFirst(array("id_contribuyente = :id_contribuyente: and id_tipodocumento = :id_tipodocumento: and numero_comprobante = :numero_comprobante: and modalidad = :modalidad: and estado_documento = 'activo'", 'bind' => array('id_contribuyente' => $id_contribuyente, 'id_tipodocumento' => $id_tipodoc_electronico, 'numero_comprobante' => $numero_comprobante, 'modalidad' => $tipo_envio_sunat)));
		}

		if(!$documento) {
			$resp['respuesta'] = 'error';
			$resp['titulo'] = 'No Existe el Documento';
			$resp['mensaje'] = 'documento no encontrado';
			return $resp;
		}

		$usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
		
		if($tipo_log == 'comunicacion_baja') {
			$log = new LogDocumento();
			$log->id_contribuyente = $id_contribuyente;
			$log->id_tipodoc_electronico = $id_tipodoc_electronico;
			$log->serie_comprobante = $serie_comprobante;
			$log->numero_comprobante = $numero_comprobante;
			$log->tipo_envio_sunat = $tipo_envio_sunat;
			$log->idusuario = $idusuario;
			$log->fecha_registro = date('Y-m-d H:i:s');
			$log->tipo = $tipo_log;
			$log->descripcion = (empty($descripcion))?"El Usuario ".$usuario->nombre.' '.$usuario->apellido.' (ID: '.$usuario->idusuario.') ha realizado una comunicación de baja o anulación para el comprobante.':$descripcion;
			$log->save();

			$resp['respuesta'] = 'ok';
			return $resp;
		}

		if($tipo_log == 'anulacion') {
			$log = new LogDocumento();
			$log->id_contribuyente = $id_contribuyente;
			$log->id_tipodoc_electronico = $id_tipodoc_electronico;
			$log->serie_comprobante = $serie_comprobante;
			$log->numero_comprobante = $numero_comprobante;
			$log->tipo_envio_sunat = $tipo_envio_sunat;
			$log->idusuario = $idusuario;
			$log->fecha_registro = date('Y-m-d H:i:s');
			$log->tipo = $tipo_log;
			$log->descripcion = (empty($descripcion))?"El Usuario ".$usuario->nombre.' '.$usuario->apellido.' (ID: '.$usuario->idusuario.') ha realizado una comunicación de baja o anulación para el comprobante.':$descripcion;
			
			$log->save();

			$resp['respuesta'] = 'ok';
			return $resp;
		}

		$resp['respuesta'] = 'ok';
		return $resp;
	}
}
?>