<?php

use Phalcon\Validation;
use Phalcon\Validation\Validator\Email as EmailValidator;

class Usuario extends \Phalcon\Mvc\Model
{

    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $idusuario;

    /**
     *
     * @var string
     * @Column(type="string", length=14, nullable=false)
     */
    public $codigo;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_rol;

    /**
     *
     * @var string
     * @Column(type="string", length=100, nullable=false)
     */
    public $nombre;

    /**
     *
     * @var string
     * @Column(type="string", length=100, nullable=false)
     */
    public $apellido;

    /**
     *
     * @var string
     * @Column(type="string", length=25, nullable=true)
     */
    public $celular;

    /**
     *
     * @var string
     * @Column(type="string", length=25, nullable=true)
     */
    public $telefono;

    /**
     *
     * @var string
     * @Column(type="string", length=150, nullable=false)
     */
    public $email;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=false)
     */
    public $password;
    public $url_image;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_contribuyente;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_registro;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $estado;

    public $idsucursal;
    
    public $ver_ventas_totales;
    public $modificacion_almacen;
    public $modificacion_multi_almacen;
    public $ventas_multisucursal;
    public $acceso_mod_compras;
    public $validar_precio_minimo;

    public $permisos;

    /**
     * Validations and business logic
     *
     * @return boolean
     */
    public function validation()
    {
        $validator = new Validation();

        $validator->add(
            'email',
            new EmailValidator(
                [
                    'model'   => $this,
                    'message' => 'Please enter a correct email address',
                ]
            )
        );

        return $this->validate($validator);
    }

    /**
     * Initialize method for model.
     */ 
    public function initialize()
    {
        $this->setSchema("juantufacturaya_sisv72");
        $this->setSource("usuario");
    }

    /**
     * Returns table name mapped in the model.
     *
     * @return string
     */
    public function getSource()
    {
        return 'usuario';
    }

    /**
     * Allows to query a set of records that match the specified conditions
     *
     * @param mixed $parameters
     * @return Usuario[]|Usuario|\Phalcon\Mvc\Model\ResultSetInterface
     */
    public static function find($parameters = null)
    {
        return parent::find($parameters);
    }

    /**
     * Allows to query the first record that match the specified conditions
     *
     * @param mixed $parameters
     * @return Usuario|\Phalcon\Mvc\Model\ResultInterface
     */
    public static function findFirst($parameters = null)
    {
        return parent::findFirst($parameters);
    }

}
