<?php

class Producto extends \Phalcon\Mvc\Model
{

    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $idproducto;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_contribuyente;

    public $idsucursal;

    /**
     *
     * @var string
     * @Column(type="string", length=14, nullable=false)
     */
    public $codigo;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_unidad_medida;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $id_cod_detraccion;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=false)
     */
    public $id_tipoafectacionigv;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $id_categoria;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=false)
     */
    public $nombre;

    /**
     *
     * @var string
     * @Column(type="string", length=11, nullable=false)
     */
    public $id_cod_moneda;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=false)
     */
    public $precio_compra;
    public $valor_sin_igv;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=false)
     */
    public $valor_con_igv;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $nota;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $foto;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=false)
     */
    public $stock;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=false)
     */
    public $stock_minimo;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_registro;
    public $precio_venta_minimo;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $estado;

    public $tipo_cambio_sunat;
    public $multi_precio;
    public $fecha_vencimiento;
    public $marca;
    public $afecto_icbper;
    public $codigos_presentaciones;
    public $porcentaje_pventa;
    public $porcentaje_pminimo;
    public $costo_promedio;
    public $peso;

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $this->setSchema("juantufacturaya_sisv72");
        $this->setSource("producto");
    }

    /**
     * Returns table name mapped in the model.
     *
     * @return string
     */
    public function getSource()
    {
        return 'producto';
    }

    /**
     * Allows to query a set of records that match the specified conditions
     *
     * @param mixed $parameters
     * @return Producto[]|Producto|\Phalcon\Mvc\Model\ResultSetInterface
     */
    public static function find($parameters = null)
    {
        return parent::find($parameters);
    }

    /**
     * Allows to query the first record that match the specified conditions
     *
     * @param mixed $parameters
     * @return Producto|\Phalcon\Mvc\Model\ResultInterface
     */
    public static function findFirst($parameters = null)
    {
        return parent::findFirst($parameters);
    }

}
