<?php

class DocElectronico extends \Phalcon\Mvc\Model
{

    /**
     *
     * @var integer
     * @Primary
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_contribuyente;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=2, nullable=false)
     */
    public $id_tipodoc_electronico;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=4, nullable=false)
     */
    public $serie_comprobante;

    /**
     *
     * @var integer
     * @Primary
     * @Column(type="integer", length=11, nullable=false)
     */
    public $numero_comprobante;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=true)
     */
    public $id_tipo_operacion;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_gravadas;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_inafecta;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_exoneradas;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_gratuitas;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_exportacion;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_descuento;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $porcentaje_descuento_total;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $sub_total;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $porcentaje_igv;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_igv;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_isc;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total_otr_imp;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $total;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $total_letras;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $nro_guia_remision;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=true)
     */
    public $cod_guia_remision;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $nro_otr_comprobante;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_comprobante;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $fecha_vto_comprobante;

    /**
     *
     * @var string
     * @Column(type="string", length=5, nullable=false)
     */
    public $tipo_cambio_sunat;
    public $id_codigomoneda;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $idcliente;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_vendedor;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $id_sucursal;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $fecha_registro;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $nota;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $id_motivotraslado;
    public $fecha_traslado;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $motivo_traslado;

    /**
     *
     * @var double
     * @Column(type="double", length=10, nullable=true)
     */
    public $peso;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $numero_paquetes;
    public $id_codigopuerto;
    public $numero_contenedor;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $id_modalidadtraslado;
    public $modalidad_traslado;

    /**
     *
     * @var string
     * @Column(type="string", length=1, nullable=true)
     */
    public $id_tipo_documento_transporte;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $nro_documento_transporte;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $razon_social_transporte;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $id_ubigeo_destino;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $dir_destino;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $id_ubigeo_partida;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $dir_partida;

    public $array_docs_referencia;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $id_tipo_comprobante_modifica;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=true)
     */
    public $serie_documento_modifica;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $nro_documento_modifica;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $id_cod_tipomotivo_credito;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $descripcion_motivo_credito;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $id_cod_tipomotivo_debito;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $descripcion_motivo_debito;
    
    public $id_condicionpago;
    public $cpago_nrooperacion;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $fecha_envio_sunat;

    /**
     *
     * @var string
     * @Column(type="string", length=25, nullable=false)
     */
    public $estado_envio_sunat;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $hash_cpe;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $hash_cdr;

    /**
     *
     * @var string
     * @Column(type="string", length=15, nullable=true)
     */
    public $cod_sunat;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $msje_sunat;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $ruta_xml;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $name_xml;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $name_xml_zip;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $name_cdr;

    /**
     *
     * @var string
     * @Column(type="string", length=250, nullable=true)
     */
    public $name_cdr_zip;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $intentos_envio_sunat;

    /**
     *
     * @var string
     * @Column(type="string", length=11, nullable=false)
     */
    public $estado_documento;

    /**
     *
     * @var string
     * @Column(type="string", length=25, nullable=false)
     */
    public $tipo_envio_sunat;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $rb_id_contribuyente;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=true)
     */
    public $rb_codigo;

    /**
     *
     * @var string
     * @Column(type="string", length=8, nullable=true)
     */
    public $rb_serie;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=true)
     */
    public $rb_secuencia;

    public $id_etransporte;
    public $id_vehiculo;
    public $transporte_nro_placa;
    public $idconductor;
    public $id_tipodoc_conductor;
    public $num_doc_conductor;
    public $nombre_completo_conductor;
    public $monto_adeudado;
    public $monto_adeudado_inicial;
    public $fecha_pagopendiente;
    public $log_condicion_pago;

    public $percepcion_idtipo;
    public $percepcion_montobase;
    public $percepcion_porcentaje;
    public $percepcion_monto;

    public $detraccion_id_mediopago;
    public $detraccion_cuenta;
    public $detraccion_iddetraccion;
    public $detraccion_porcentaje;
    public $detraccion_monto;
    public $detraccion_texto;

    public $cpago_fechadeposito;
	public $cpago_idbanco;
    public $ignorar_documento; //si, no, null
    public $licencia_conductor;

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $this->setSchema("juantufacturaya_sisv72");
        $this->setSource("doc_electronico");
    }

    /**
     * Returns table name mapped in the model.
     *
     * @return string
     */
    public function getSource()
    {
        return 'doc_electronico';
    }

    /**
     * Allows to query a set of records that match the specified conditions
     *
     * @param mixed $parameters
     * @return DocElectronico[]|DocElectronico|\Phalcon\Mvc\Model\ResultSetInterface
     */
    public static function find($parameters = null)
    {
        return parent::find($parameters);
    }

    /**
     * Allows to query the first record that match the specified conditions
     *
     * @param mixed $parameters
     * @return DocElectronico|\Phalcon\Mvc\Model\ResultInterface
     */
    public static function findFirst($parameters = null)
    {
        return parent::findFirst($parameters);
    }

}
