<?php
ini_set( 'serialize_precision', -1 );
use Phalcon\Mvc\Controller;
class ControllerBase extends Controller
{
    public $ruta_base_files = '/home/juantufacturaya/.files_contribuyente';
    public $ruta_base_public_html = "/home/juantufacturaya/public_html";
    public $token_user = '';// ingresa tu token de usuario
    public $data_patrocinador = array();
    public $bloquear_sunat = false;
    public $bloquear_correos = false;
    public $bloquear_busquedas = false;
    public $modalidad_envio_sunat = 'inmediato'; //'inmediato', 'solo_firma', 'no_enviar' => o vacio: cuando es vacio toma la opción del usuario
    public $culqi_secret_key_prueba = '';
    public $culqi_public_key_prueba = '';
    public $culqi_secret_key_produccion = '';
    public $culqi_public_key_produccion = '';
    public $factor_igv_sunat = 0.18;
    
    public $token_cookie = ''; // ingrese tu token cookie
    public $ruc_proveedor = ''; // ingresa tu ruc
    public $ruc_sol = '';
    public $usuario_sol = '';
    public $pass_sol = '';
    public $key_captcha_public = ''; // ingresa tu recapcha publica
    public $key_captcha_secret = ''; // ingresa tu recapcha secreta

	public function initialize()
    {
        $this->view->user = $this->getSessionUser();
        $this->view->tipo_envio_sunat = $this->get_tipo_envio_sunat();
        
        $data_empresa = $this->get_parametros_iniciales();
        $this->data_patrocinador = $data_empresa;

        $this->view->data_empresa = $data_empresa;
        $this->view->data_personalizacion = $data_empresa['custom_data_style'];
        
        $this->view->lista_grupo_vendedores = $this->lista_grupo_vendedores();
    }

    protected function lista_grupo_vendedores() {
        $auth = $this->session->get('auth');
        if (!$auth) { return array(); }

        $idusuario = $auth['idusuario'];
        $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
        if(!$usuario) { return array(); }

        $contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario->id_contribuyente)));
        if(!$contribuyente) { return array(); }

        if($contribuyente->tipo_empresa == 2) {
            //Extraer Lista de Empresas
            $id_patrocinador_grupal = $contribuyente->id_contribuyente;
        } else {
            $patrocinador = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $contribuyente->id_patrocinador)));
            if($patrocinador->tipo_empresa == 1) { return array(); }

            $id_patrocinador_grupal = $patrocinador->id_contribuyente;
        }

        $herramientas = new HerramientasController;
        $lista = array();

        $query = "SELECT * FROM usuario WHERE id_contribuyente in (select id_contribuyente from contribuyente where id_contribuyente = :id_patrocinador or id_patrocinador = :id_patrocinador) and estado = 'activo' and codigo = :codigo";
    
        try {
            $sentencia = $this->db->prepare($query);
            $sentencia->bindParam(':id_patrocinador', $id_patrocinador_grupal, PDO::PARAM_INT);
            $sentencia->bindParam(':codigo', $usuario->codigo, PDO::PARAM_STR);
            $sentencia->execute();
        } catch (Exception $e) {
            return array();
        }
        
        while($fila = $sentencia->fetch()) {
            $usuario_vendedor = (object)$fila;
            $empresa_vendedor = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario_vendedor->id_contribuyente)));

            $cadena_encriptada = $herramientas->encriptar('BBBBB777AAA999||'.$usuario_vendedor->idusuario);
            $lista[] = array(
                'ruc'           =>  $empresa_vendedor->ruc,
                'razon_social'  =>  ucwords(strtolower($empresa_vendedor->nombre_comercial)),
                'email'         =>  $usuario_vendedor->email,
                'secret_key'    =>  $cadena_encriptada,
                'url_image'     =>  $usuario_vendedor->url_image,
                'url_acceso'    =>  "/sistemav7/login/inicio_sesion_remoto?user=$cadena_encriptada"
            );
        }
        
        return $lista;
    }
    
    protected function get_parametros_iniciales() {
        $contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => 1)));
        
        if($contribuyente->https == 'si') {
            $data['https'] = 'si';
        } else {
            $data['https'] = 'no';
        }

        $data['nombre_usuario'] = '';
        $data['email_usuario'] = '';
        $data['ruc_usuario'] = '';

        $auth = $this->session->get('auth');
        $idusuario = $auth['idusuario'];
        $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
        if($usuario) {
            $data['nombre_usuario'] = $usuario->nombre.' '.$usuario->apellido;
            $data['email_usuario'] = $usuario->email;

            $usuario_empresa = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario->id_contribuyente)));
            $data['ruc_usuario'] = $usuario_empresa->ruc;
        }
        
        $data['url_domain']             = 'tufacturaya.com';
        $data['nombre_empresa']         = ucwords(trim($contribuyente->razon_social));
        $data['logo_img_461'] = 'https://facturalaya.com/sys/herramientas/verimage/imguser-639a482a90a5c-286e7fe662f7f6df1c18de59c6a3b469.png';
        $data['logo_img_291'] = 'https://facturalaya.com/sys/herramientas/verimage/imguser-639a4834da7ed-59a743b1a58440f6d5dab3d9af83d80c.png';
        $data['logo_img_56'] = 'https://facturalaya.com/sys/herramientas/verimage/imguser-639a483e74109-5920e6404bc01444a4c2b468bae359a1.png';
        $data['url_soporte']            = $contribuyente->url_soporte;
        $data['url_politica_privacidad']    = $contribuyente->url_politica_privacidad;
        $data['url_terminos_condiciones']   = $contribuyente->url_terminos_condiciones;
        $data['id_contribuyente']       = 1;
        $data['id_patrocinador']        = 1;
        $data['mostrar_chat']           = 'no';
        $data['modulo_marketing']       = 'no';
        $data['captcha_key_public']     = $this->key_captcha_public;
        $data['captcha_key_private']    = $this->key_captcha_secret;
        $data['custom_data_style']      = $this->get_custom_data_style_system(1);

        return $data;
    }
	
	protected function _checkSession(){
        $auth = $this->session->get('auth');
        if (!$auth){
            return false;
        } else {
            return true;
        }
    }

    protected function get_tipo_envio_sunat() {
        $auth = $this->session->get('auth');
        if (!$auth){
            return '';
        }
        
        $idusuario = $auth['idusuario'];
        $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
        if(!$usuario) {
            return '';
        }
        $contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario->id_contribuyente)));
        if(!$contribuyente) {
            return '';
        }
        
        if($contribuyente->tipo_envio_sunat == 'prueba') {
            $ambiente = 'Ambiente de Pruebas';
        } else {
            $ambiente = 'Ambiente de Producción';
        }
        return $ambiente;
    }
    
    protected function registrar_sesion($user, $redirect = true) {
        $auth = $this->session->set('auth', $user);
       
        if ($this->cookies->has('logout_c_5939')){
            $rememberMe = $this->cookies->get("logout_c_5939");
            $rememberMe->delete();
        }

        $this->crear_cookie_session($user['idusuario']);
        if($redirect) {
            $this->redirect_user($user);
        }
    }

    protected function redirect_user($user) {
        $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $user['idusuario'])));
        $contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario->id_contribuyente)));
        $lista_patrocinadores = $this->get_lista_patrocinadores($contribuyente->id_contribuyente);
        
        $dominio = $_SERVER['HTTP_HOST'];
        $dominio = str_replace('www.', '', $dominio);
        header("Location: https://$dominio/sistemav7/dashboard");
        exit();
    }

    protected function get_lista_patrocinadores($id_contribuyente) {
        $lista_patrocinadores[] = 1;
        return $lista_patrocinadores;
    }
	
	protected function getSessionUser(){
        $auth = $this->session->get('auth');
        if (!$auth){
            return null;
        } else {
            return $auth;
        }
    }

    protected function microtime_float() {
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }

    protected function inicio_ejecucion() {
        return microtime(true);
    }

    protected function fin_ejecucion($time_inicio) {
        $end = microtime(true);
        return $end - $time_inicio;
    }

    protected function crear_cookie_session($idusuario) {
        if ($this->cookies->has('logout_c_5939')){
            $rememberMe = $this->cookies->get("logout_c_5939");
            $rememberMe->delete();
        }

        $herramientas = new HerramientasController;
        $texto_encriptar = $idusuario.'||'.date('dmY');
        $id_usuario_encripted = $herramientas->encriptar($texto_encriptar);
        $resp = $this->cookies->set('logout_c_5939', $id_usuario_encripted, time() + 5 * 3600);
        $this->cookies->send();
    }

    protected function eliminar_cookie_session() {
        if ($this->cookies->has('logout_c_5939')){
            $rememberMe = $this->cookies->get("logout_c_5939");
            $rememberMe->delete();
        }
    }

    protected function get_contribuyente_opciones($id_contribuyente) {
        $id_contribuyente = intval($id_contribuyente) + 0;
        //Valores por defecto: Siempre se deben inicializar.
        $opciones = array();
        $opciones['color_fondo_tipo'] = 'color_degradado';
        $opciones['color_fondo_1_rgb'] = '#3f51b5';
        $opciones['color_fondo_2_rgb'] = '#7880f0';
        $opciones['id_plantilla_login'] = 1;
        $opciones['id_plantilla_registro'] = 14;
        $opciones['img_background_login'] = 'https://tufacturaya.com/sistemav7/img/38.jpg';
        $opciones['img_background_register'] = 'https://tufacturaya.com/sistemav7/img/hero-6.jpg';
        $opciones['msj_expira_suscripcion'] = 'Su Suscripción ha vencido por favor renovar su sucripción lo antes posible.';

        $contribuyente_opciones = ContribuyenteOpciones::find(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $id_contribuyente)));
        foreach($contribuyente_opciones as $contribuyente_opcion) {
            $opciones[$contribuyente_opcion->opcion_nombre] = $contribuyente_opcion->opcion_valor;
        }

        return $opciones;
    }

    //aquí se inicializan los datos (se deben cambiar los datos de inicialización)
    protected function set_contribuyente_opciones($id_contribuyente, $opcion_nombre, $opcion_valor) {
        if(empty($opcion_valor)) {
            $resp['respuesta'] = 'error';
            $resp['titulo'] = 'Error';
            $resp['mensaje'] = 'No se permiten valores vacíos';
            return $resp;
        }

        $contribuyente_opcion = ContribuyenteOpciones::findFirst(array("id_contribuyente = :id_contribuyente: and opcion_nombre = :opcion_nombre:", 'bind' => array('id_contribuyente' => $id_contribuyente, 'opcion_nombre' => $opcion_nombre)));

        if($contribuyente_opcion) {
            if($contribuyente_opcion->opcion_valor == $opcion_valor) {
                $resp['respuesta'] = 'ok';
                return $resp;
            }

            $contribuyente_opcion->opcion_valor = $opcion_valor;
            if(!$contribuyente_opcion->save()) {
                $msg = '';
                foreach ($contribuyente_opcion->getMessages() as $message) {
                    $msg = $msg.$message."</br>\n";
                }
    
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error';
                $resp['mensaje'] = $msg;
                return $resp;
            }

            $resp['respuesta'] = 'ok';
            return $resp;
        }

        $contribuyente_opcion = new ContribuyenteOpciones();
        $contribuyente_opcion->id_contribuyente = $id_contribuyente;
        $contribuyente_opcion->opcion_nombre = $opcion_nombre;
        $contribuyente_opcion->opcion_valor = $opcion_valor;
        if(!$contribuyente_opcion->save()) {
            $msg = '';
            foreach ($contribuyente_opcion->getMessages() as $message) {
                $msg = $msg.$message."</br>\n";
            }

            $resp['respuesta'] = 'error';
            $resp['titulo'] = 'Error';
            $resp['mensaje'] = $msg;
            return $resp;
        }

        $resp['respuesta'] = 'ok';
        return $resp;
    }

    protected function get_contribuyente_opcion($id_contribuyente, $opcion_nombre) {
        $contribuyente_opcion = ContribuyenteOpciones::findFirst(array("id_contribuyente = :id_contribuyente: and opcion_nombre = :opcion_nombre:", 'bind' => array('id_contribuyente' => $id_contribuyente, 'opcion_nombre' => $opcion_nombre)));
        if(!$contribuyente_opcion) {
            return '';
        }

        return $contribuyente_opcion->opcion_valor;
    }

    protected function get_custom_data_style_system($id_contribuyente) {
        $contribuyente_opciones = $this->get_contribuyente_opciones($id_contribuyente);

        $data = array();
        $data['id_plantilla_login'] = isset($contribuyente_opciones['id_plantilla_login'])?intval($contribuyente_opciones['id_plantilla_login']) + 0:1;
        $data['id_plantilla_registro'] = isset($contribuyente_opciones['id_plantilla_registro'])?intval($contribuyente_opciones['id_plantilla_registro']) + 0:14;
        $data['img_background_login'] = isset($contribuyente_opciones['img_background_login'])?$contribuyente_opciones['img_background_login']:'https://tufacturaya.com/sistemav7/img/38.jpg';
        $data['img_background_register'] = isset($contribuyente_opciones['img_background_register'])?$contribuyente_opciones['img_background_register']:'https://tufacturaya.com/sistemav7/img/hero-6.jpg';

        //INICIO DE VALIDACIONES PARA PODER EXTRAER EL VALOR CORRECTO PARA LOS COLORES
        //Es muy importante que tenga valores correctos porque puede ocasionar un problema muy grande en el sistema
        $color_base_sistema = isset($contribuyente_opciones['color_base_sistema'])?$contribuyente_opciones['color_base_sistema']:'{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}';
        $color_base_sistema = @json_decode($color_base_sistema);
        if($color_base_sistema === null) {
            $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
        }

        if(!isset($color_base_sistema->tipo_color)) {
            $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
        }

        if($color_base_sistema->tipo_color != 'color_degradado' && $color_base_sistema->tipo_color != 'color_solido') {
            $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
        } else {
            if($color_base_sistema->tipo_color == 'color_degradado') {
                if(!isset($color_base_sistema->color_1) || !isset($color_base_sistema->color_2)) {
                    $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
                } else {
                    if(!preg_match("/^#[a-zA-Z0-9_]{6}$/", $color_base_sistema->color_1) || !preg_match("/^#[a-zA-Z0-9_]{6}$/", $color_base_sistema->color_2)) {
                        $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
                    }
                }
            } else {
                if(!isset($color_base_sistema->color_solido)) {
                    $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
                } else {
                    if(!preg_match("/^#[a-zA-Z0-9_]{6}$/", $color_base_sistema->color_solido)) {
                        $color_base_sistema = json_decode('{"tipo_color":"color_degradado","color_1":"#3f51b5","color_2":"#7880f0"}');
                    }
                }
            }
        }
        //FIN validación para colores base de sistema

        //este código es especial porque así se trabajó el cambio de color en toda la plantilla:
        if($color_base_sistema->tipo_color == 'color_degradado') {
            $data['color_fondo_1_rgb'] = $color_base_sistema->color_1;
            $data['color_fondo_2_rgb'] = $color_base_sistema->color_2;
        } else {
            $data['color_fondo_1_rgb'] = $color_base_sistema->color_solido;
            $data['color_fondo_2_rgb'] = $color_base_sistema->color_solido;
        }

        $data['color_base_sistema'] = $color_base_sistema;
        return $data;
    }

    protected function get_data_suscripcion($idusuario) {
        $resp['tiene_suscripcion'] = 'no';
        $resp['fecha_expira_suscripcion'] = '';
        $resp['dias_restantes_suscripcion'] = 0;

        $resp['tipo_certificado'] = 'propio';
        $resp['fecha_expira_certificado'] = '';
        $resp['dias_restantes_certificado'] = 0;

        $resp['ambiente'] = 'pruebas';

        $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
        if($usuario) {
            $contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $usuario->id_contribuyente)));
            if($contribuyente) {
                $resp['ambiente'] = $contribuyente->tipo_envio_sunat;

                $herramientas = new HerramientasController;
                if(!empty($contribuyente->fecha_expiracion)) {
                    $resp_fecha_suscripcion = $herramientas->comparar_fechas($contribuyente->fecha_expiracion, date('Y-m-d'));
                    $resp['tiene_suscripcion'] = 'no';
                    $resp['fecha_expira_suscripcion'] = date("d-m-Y / H:i A", strtotime($contribuyente->fecha_expiracion));
                    $resp['dias_restantes_suscripcion'] = $resp_fecha_suscripcion['diferencia_primera_segunda'];
                    
                }

                if(!empty($contribuyente->fecha_expira_cert)) {
                    $resp_fecha_certificado = $herramientas->comparar_fechas($contribuyente->fecha_expira_cert, date('Y-m-d'));
                    $resp['tipo_certificado'] = $contribuyente->tipo_certificado;
                    $resp['fecha_expira_certificado'] = date("d-m-Y / H:i A", strtotime($contribuyente->fecha_expira_cert));
                    $resp['dias_restantes_certificado'] = $resp_fecha_certificado['diferencia_primera_segunda'];
                }
            }
        }

        return $resp;
    }

    protected function get_html_suscripcion($data_suscripcion) {
        $html = '';
        $html_suscripcion = '';
        $html_certificado = '';
        $suscripcion_activa = 'si';

        if($data_suscripcion['ambiente'] == 'produccion') {
            if($data_suscripcion['dias_restantes_suscripcion'] <= 7) {
                if($data_suscripcion['dias_restantes_suscripcion'] >= 0) {
                    if($data_suscripcion['dias_restantes_suscripcion'] >= 3) {
                        $html_suscripcion = '
                        <div class="alert alert-warning alert-styled-right" style="margin-top: 25px;">
                            <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                            Tu suscripción finaliza el día: '.$data_suscripcion['fecha_expira_suscripcion'].', debes renovar tu suscripción a la brevedad posible... 
                        </div>
                        ';
                    } else {
                        $html_suscripcion = '
                        <div class="alert alert-danger alert-styled-right" style="margin-top: 25px;">
                            <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                            Tu suscripción finaliza el día: '.$data_suscripcion['fecha_expira_suscripcion'].', ya solo faltan '.$data_suscripcion['dias_restantes_suscripcion'].' días, renueva a la brevedad posible... 
                        </div>
                        ';
                    }
                } else {
                    $html_suscripcion = '
                    <div class="alert alert-danger alert-styled-right" style="margin-top: 25px;">
                        <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                        Tu suscripción ha cadudado el día: '.$data_suscripcion['fecha_expira_suscripcion'].', renueva a la brevedad posible... 
                    </div>
                    ';
                    $suscripcion_activa = 'no';
                }
            }
            
            if($data_suscripcion['tipo_certificado'] != 'propio') {
                if($data_suscripcion['dias_restantes_certificado'] <= 7) {
                    if($data_suscripcion['dias_restantes_certificado'] >= 0) {
                        if($data_suscripcion['dias_restantes_certificado'] >= 3) {
                            $html_certificado = '
                            <div class="alert alert-warning alert-styled-right" style="margin-top: 25px;">
                                <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                                La activación de tu certificado finaliza el día: '.$data_suscripcion['fecha_expira_certificado'].', debes renovar tu certificado lo antes posible para evitar cortes en el envío de documentos electrónicos... 
                            </div>
                            ';
                        } else {
                            $html_certificado = '
                            <div class="alert alert-danger alert-styled-right" style="margin-top: 25px;">
                                <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                                La activación de tu certificado finaliza el día: '.$data_suscripcion['fecha_expira_certificado'].', ya solo faltan '.$data_suscripcion['dias_restantes_certificado'].' días, renueva a la brevedad posible... 
                            </div>
                            ';
                        }
                    } else {
                        $html_certificado = '
                        <div class="alert alert-danger alert-styled-right" style="margin-top: 25px;">
                            <button type="button" class="close" data-dismiss="alert"><span>×</span><span class="sr-only">Close</span></button>
                            Tu certificado ha vencido el día: '.$data_suscripcion['fecha_expira_certificado'].', renueva a la brevedad posible... 
                        </div>
                        ';
                        $suscripcion_activa = 'no';
                    }
                }
            }

            if($html_suscripcion != '' || $html_certificado != '') {
                $html = '
                <div class="page-header-content" style="max-width: 1100px; margin: 0 auto;">
                '.$html_suscripcion.$html_certificado.'
                </div>
                ';
            }
        }

        $resp['html'] = $html;
        $resp['suscripcion_activa'] = $suscripcion_activa;
        return $resp;
    }

    public function validar_suscripcion($id_contribuyente) {
		$resp['tipo_acceso'] = 'libre'; //libre,
		$resp['tiene_suscripcion'] = 'no';
        $resp['fecha_expira_suscripcion'] = '';
		$resp['dias_restantes_suscripcion'] = 0;
		$resp['mensaje_expira'] = '';
		
		$contribuyente = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $id_contribuyente)));

		if($contribuyente->id_contribuyente == 1) {
			return $resp;
		}

		//si el usuario está en modo prueba, entonces se le deja acceso libre
		if($contribuyente->tipo_envio_sunat == 'prueba') {
			//aquí también se debería verificar si algún usuario está utilizando el sistema para control interno solamente
			return $resp;
		}

		if($contribuyente->id_patrocinador == 1) {
			$resp['mensaje_expira'] = 'Debe Realizar su Depósito a la Siguiente Cuenta en el BCP: 245-9603-5269-0-47 a Nombre de FacturalaYa SRL, y luego enviar una captura del voucher via whatsapp al siguiente número: 956295282 incluyendo tu número de RUC.';
		} else {
			$patrocinador = Contribuyente::findFirst(array("id_contribuyente = :id_contribuyente:", 'bind' => array('id_contribuyente' => $contribuyente->id_patrocinador)));
			$resp['mensaje_expira'] = 'Puedes contactar al siguiente número de celular: '.$patrocinador->telefono.', y/o al siguiente email: '.$patrocinador->email.'.';
		}
        
		$herramientas = new HerramientasController;

		//Aquí ingresa si el usuario ya tiene suscripciones activas...
		$resp_fecha = $herramientas->comparar_fechas($contribuyente->fecha_expiracion, date('Y-m-d'));
		$resp['tipo_acceso'] = 'restringido';
		$resp['tiene_suscripcion'] = 'si';
        $resp['fecha_expira_suscripcion'] = date("d-m-Y / H:i A", strtotime($contribuyente->fecha_expiracion));
		$resp['dias_restantes_suscripcion'] = $resp_fecha['diferencia_primera_segunda'];

		return $resp;
	}
}
