<?php
class ProfileController extends ControllerBase
{
	public function indexAction($tab = '') {
		$this->tag->setTitle('Perfil');
        $this->view->setTemplateAfter('templatenew');

        $this->assets
        ->addCss("css/main-indigo.css")
        ->addCss("css/new_style.css");
        $this->assets
        ->addJs("template/assets/js/plugins/forms/styling/switchery.min.js?i=v2")
        ->addJs("template/assets/js/plugins/forms/styling/uniform.min.js?i=v2")
        ->addJs("template/assets/js/plugins/forms/selects/select2.min.js?i=v2")
        ->addJs("template/assets/js/plugins/tables/datatables/datatables.min.js?i=v2")
        ->addJs("template/assets/js/core/app.js?i=v2")
       ->addJs("template/assets/js/core/libraries/jquery_ui/core.min.js?i=v2")
        ->addJs("template/assets/js/plugins/uploaders/fileinput/fileinput.min.js?i=v2")
        ->addJs("template/assets/js/plugins/media/cropper.min.js?i=v2")
        ->addJs("template/assets/js/plugins/forms/styling/uniform.min.js?i=v2")
        ->addJs("template/assets/js/plugins/forms/styling/switchery.min.js?i=v2")
        ->addJs("template/assets/js/plugins/forms/styling/switch.min.js?i=v2")
        ->addJs("template/assets/js/core/app.js?i=v2")
        ->addJs("js/general.js?j=".rand()) 
        ->addJs("js/subir_imagen.js?i=v4")
        ->addJs("js/profile.js?i=v4");
        
		$auth = $this->session->get('auth');
        $idusuario = $auth['idusuario'];
        $usuario = Usuario::findFirst("idusuario = ".$idusuario)->toArray();
        if(!$usuario) {
            $resp['respuesta'] = 'error';
            $resp['titulo'] = 'Error en Usuario';
            $resp['mensaje'] = 'Lo sentimos! Es posible que se haya cerrado la sessión, <a style="color: #1c81d1;" href="/session" target="_blank">haz click aquí para ingresar de nuevo</a>, luego de iniciar sessión, puedes regresar a esta pantalla y recargar la página y continuar...';
            echo json_encode($resp);
            exit();
        }
        
        
        if($tab != 'perfil' && $tab != 'seguridad' && $tab != 'facturacion') {
            $tab = 'perfil';
        }
        $this->view->tab = $tab;
        $this->view->usuario = $usuario; 
        
    }
    
    public function saveAction(){
        $this->view->disable();
        $request = $this->request;
        if($request->isAjax() == true){
            $datapost = $this->request->getPost();
            $auth = $this->session->get('auth');
            $idusuario = $auth['idusuario'];
            
            $codigo = $datapost['codigo'];
            $nombre = $datapost['nombre'];
            $apellido = $datapost['apellido'];
            $celular = $datapost['celular'];
            $telefono = $datapost['telefono'];
            $url_image = $datapost['imagen_usuario'];
           
            //Validación de sesion
            $usuario = Usuario::findFirst(array("idusuario = :idusuario:", 'bind' => array('idusuario' => $idusuario)));
            if(!$usuario) {
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Usuario';
                $resp['mensaje'] = 'Lo sentimos! Es posible que se haya cerrado la sessión, <a style="color: #1c81d1;" href="/session" target="_blank">haz click aquí para ingresar de nuevo</a>, luego de iniciar sessión, puedes regresar a esta pantalla y recargar la página y continuar...';
                echo json_encode($resp);
                exit();
            }
            //Validacion de cambios
            if(empty($codigo)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Código';
                $resp['mensaje'] = 'Lo sentimos! No se permiten campos vacíos, por favor, ingrese o genere un código';
                echo json_encode($resp);
                exit();
            }
            if(empty($nombre)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Nombre';
                $resp['mensaje'] = 'Lo sentimos! No se permiten campos vacíos, por favor, ingrese un nombre';
                echo json_encode($resp);
                exit();
            }
            if(empty($apellido)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Apellido';
                $resp['mensaje'] = 'Lo sentimos! No se permiten campos vacíos, por favor, ingrese un apellido';
                echo json_encode($resp);
                exit();
            }
            if(empty($telefono)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Teléfono';
                $resp['mensaje'] = 'Lo sentimos! No se permiten campos vacíos, por favor, ingrese un número de teléfono';
                echo json_encode($resp);
                exit();
            }
            if(empty($celular)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Celular';
                $resp['mensaje'] = 'Lo sentimos! No se permiten campos vacíos, por favor, ingrese un número de celular';
                echo json_encode($resp);
                exit();
            }
            if(empty($url_image)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Imágen';
                $resp['mensaje'] = 'Debes agregar tu imágen de perfil!';
                echo json_encode($resp);
                exit();
            }
            $user = Usuario::findFirst(array('idusuario = :idusuario:', 'bind' =>  array('idusuario' => $idusuario)));
            $user->codigo = $codigo;
            $user->nombre = $nombre;
            $user->apellido = $apellido;
            $user->telefono = $telefono;
            $user->celular = $celular;
            $user->url_image = $url_image;

            if(!$user->save()) {
                $msg = '';
                foreach ($user->getMessages() as $message) {
                    $msg = $msg.$message."</br>\n";
                }
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error';
                $resp['mensaje'] = 'No se han podido guardar los datos';
                echo json_encode($resp);
                exit();
            }
            $resp['respuesta'] = 'ok';
            $resp['titulo'] = '¡Enhorabuena!';
            $resp['mensaje'] = 'Todos los datos se han guardado exitosamente!';
            echo json_encode($resp);
            exit();
            
        }
    }
    public function save_emailAction(){
        $this->view->disable();
        $request = $this->request;
        if($request->isAjax() == true){
            $datapost = $this->request->getPost();
            $auth = $this->session->get('auth');
            $idusuario = $auth['idusuario'];
            $email = $datapost['email'];
            
             if(empty($email)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Código';
                $resp['mensaje'] = 'Lo sentimos! Es obligatorio que ingreses un correo eléctronico, puesto que con él es que accederás a nuestro sistema';
                echo json_encode($resp);
                exit();
            }

            //Verificando que si el email ingresado ya existe
           $sql_email = Usuario::findFirst(array('email = :email: and idusuario <> :idusuario:', 'bind' =>  array('email' => $email, 'idusuario' => $idusuario)));
            if($sql_email) {
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Email';
                $resp['mensaje'] = 'Lo sentimos! El email ingresado ya existe en nuestro sistema, por seguridad, te invitamos a ingresar otro!';
                echo json_encode($resp);
                exit();
            }

            $user = Usuario::findFirst(array('idusuario = :idusuario: ', 'bind' =>  array('idusuario' => $idusuario)));
            $user->email = $email;
            if(!$user->save()) {
                $msg = '';
                foreach ($user->getMessages() as $message) {
                    $msg = $msg.$message."</br>\n";
                }
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error';
                $resp['mensaje'] = 'No se han podido guardar los datos';
                echo json_encode($resp);
                exit();
            }
            $resp['respuesta'] = 'ok';
            $resp['titulo'] = '¡Enhorabuena!';
            $resp['mensaje'] = 'El nuevo email  se ha guardado exitosamente! Recuerda que para la próxima sesión debes ingresar con él.';
            echo json_encode($resp);
            exit();
        }
    }
    public function save_passwordAction(){
        $this->view->disable();
        $request = $this->request;
        if($request->isAjax() == true){
            $datapost = $this->request->getPost();
            $auth = $this->session->get('auth');
            $idusuario = $auth['idusuario'];

            $password = $datapost['password'];
            $new_password = $datapost['new_password'];
            
             if(empty($password)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Código';
                $resp['mensaje'] = 'Lo sentimos! Es obligatorio que ingreses la anterior contraseña';
                echo json_encode($resp);
                exit();
            }
            if(empty($new_password)){
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Código';
                $resp['mensaje'] = 'Lo sentimos! Es obligatorio que ingreses una contraseña, puesto que con ella es que accederás a nuestro sistema';
                echo json_encode($resp);
                exit();
            }
            //Verificando que si la contraseña es correcta
            $sql_password = Usuario::findFirst(array('idusuario = :idusuario: and password = :password:', 'bind' =>  array('idusuario' => $idusuario, 'password' => $password)));
            if(!$sql_password) {
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error en Contraseña';
                $resp['mensaje'] = 'Lo sentimos! La contraseña ingresada es incorrecta, intenta nuevamente!';
                echo json_encode($resp);
                exit();
            }
            $user = Usuario::findFirst(array('idusuario = :idusuario: ', 'bind' =>  array('idusuario' => $idusuario)));
            $user->password = $new_password;
            if(!$user->save()) {
                $msg = '';
                foreach ($user->getMessages() as $message) {
                    $msg = $msg.$message."</br>\n";
                }
                $resp['respuesta'] = 'error';
                $resp['titulo'] = 'Error';
                $resp['mensaje'] = 'No se han podido guardar los datos';
                echo json_encode($resp);
                exit();
            }

            $enviaremail = new EnviaremailController;
            $resp_email = $enviaremail->enviar_cambio_password($idusuario);

            $resp['respuesta'] = 'ok';
            $resp['titulo'] = '¡Enhorabuena!';
            $resp['mensaje'] = 'La nueva contraseña se ha guardado exitosamente! Recuerda que para la próxima sesión debes ingresar con él.';
            echo json_encode($resp);
            exit();
        }
        
    }

}
?>